/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.outline;

import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.ruby.core.IRubyElement;
import com.aptana.ruby.core.IRubyMethod;
import com.aptana.ruby.core.IRubyType;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RubyOutlineLabelProvider
extends LabelProvider {
    static final Image CLASS = RubyEditorPlugin.getImage("icons/class_obj.png");
    private static final Image MODULE = RubyEditorPlugin.getImage("icons/module_obj.png");
    private static final Image METHOD_PUBLIC = RubyEditorPlugin.getImage("icons/method_public_obj.png");
    private static final Image METHOD_PROTECTED = RubyEditorPlugin.getImage("icons/method_protected_obj.png");
    private static final Image METHOD_PRIVATE = RubyEditorPlugin.getImage("icons/method_private_obj.png");
    private static final Image METHOD_SINGLETON = RubyEditorPlugin.getImage("icons/class_method.png");
    static final Image METHOD_CONSTRUCTOR = RubyEditorPlugin.getImage("icons/constructor.png");
    private static final Image CLASS_VAR = RubyEditorPlugin.getImage("icons/class_var_obj.png");
    private static final Image CONSTANT = RubyEditorPlugin.getImage("icons/constant_obj.png");
    private static final Image GLOBAL = RubyEditorPlugin.getImage("icons/global_obj.png");
    static final Image INSTANCE_VAR = RubyEditorPlugin.getImage("icons/instance_var_obj.png");
    static final Image LOCAL_VAR = RubyEditorPlugin.getImage("icons/local_var_obj.png");
    private static final Image IMPORT_DECLARATION = RubyEditorPlugin.getImage("icons/import_obj.png");
    private static final Image IMPORT_CONTAINER = RubyEditorPlugin.getImage("icons/import_container_obj.png");

    public Image getImage(Object element) {
        if (element instanceof CommonOutlineItem) {
            return this.getImage(((CommonOutlineItem)element).getReferenceNode());
        }
        if (element instanceof IRubyType) {
            return ((IRubyType)element).isModule() ? MODULE : CLASS;
        }
        if (element instanceof IRubyMethod) {
            IRubyMethod method = (IRubyMethod)element;
            if (method.isSingleton()) {
                return METHOD_SINGLETON;
            }
            if (method.isConstructor()) {
                return METHOD_CONSTRUCTOR;
            }
            IRubyMethod.Visibility visibility = method.getVisibility();
            switch (visibility) {
                case PUBLIC: {
                    return METHOD_PUBLIC;
                }
                case PROTECTED: {
                    return METHOD_PROTECTED;
                }
                case PRIVATE: {
                    return METHOD_PRIVATE;
                }
            }
        } else if (element instanceof IRubyElement) {
            short type = ((IRubyElement)element).getNodeType();
            switch (type) {
                case 8: {
                    return CLASS_VAR;
                }
                case 7: {
                    return CONSTANT;
                }
                case 5: {
                    return GLOBAL;
                }
                case 9: {
                    return INSTANCE_VAR;
                }
                case 10: 
                case 11: {
                    return LOCAL_VAR;
                }
                case 6: {
                    return IMPORT_DECLARATION;
                }
                case 13: {
                    return IMPORT_CONTAINER;
                }
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof CommonOutlineItem) {
            return this.getText(((CommonOutlineItem)element).getReferenceNode());
        }
        return super.getText(element);
    }
}

